class MM_TDMHUD extends MM_HUD;

#exec TEXTURE IMPORT NAME=Icon_RedTeam FILE=Textures\Icon_RedTeam.bmp GROUP="HUD" MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_BlueTeam FILE=Textures\Icon_BlueTeam.bmp GROUP="HUD" MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_GreenTeam FILE=Textures\Icon_GreenTeam.bmp GROUP="HUD" MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_GoldTeam FILE=Textures\Icon_GoldTeam.bmp GROUP="HUD" MIPS=ON

simulated function DrawGameSynopsis(Canvas Canvas)
{
local TournamentGameReplicationInfo GRI;
local int i, teams;
local float XL, YL, Ypos, YStart;

	Super.DrawGameSynopsis(Canvas);

	GRI = TournamentGameReplicationInfo(PlayerOwner.GameReplicationInfo);

	if ( GRI != None )
		{
		Teams = MonsterPRI(PlayerPawn(Owner).PlayerReplicationInfo).NumTeams;

		Ypos = 32 * Teams;
		Ystart = Canvas.ClipY * 0.5 - Ypos;

		Canvas.DrawColor = WhiteColor;
		Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
		Canvas.StrLen("0000", XL, YL);

		if ( Teams > 0 )
			{
			Canvas.Style = ERenderStyle.STY_Translucent;
			Canvas.SetPos(0, Ystart);
			Canvas.DrawTile(Texture'Icon_RedTeam', 64, 64, 0, 0, 128.0, 128.0);
			Canvas.Style = ERenderStyle.STY_Normal;
			Canvas.SetPos(64, Ystart + 32 - 0.5 * YL);
			Canvas.DrawText(int(GRI.Teams[0].Score), False);
			}
		if ( Teams > 1 )
			{
			Ystart += 64;
			Canvas.Style = ERenderStyle.STY_Translucent;
			Canvas.SetPos(0, Ystart);
			Canvas.DrawTile(Texture'Icon_BlueTeam', 64, 64, 0, 0, 128.0, 128.0);
			Canvas.Style = ERenderStyle.STY_Normal;
			Canvas.SetPos(64, Ystart + 32 - 0.5 * YL);
			Canvas.DrawText(int(GRI.Teams[1].Score), False);
			}
		if ( Teams > 2 )
			{
			Ystart += 64;
			Canvas.Style = ERenderStyle.STY_Translucent;
			Canvas.SetPos(0, Ystart);
			Canvas.DrawTile(Texture'Icon_GreenTeam', 64, 64, 0, 0, 128.0, 128.0);
			Canvas.Style = ERenderStyle.STY_Normal;
			Canvas.SetPos(64, Ystart + 32 - 0.5 * YL);
			Canvas.DrawText(int(GRI.Teams[2].Score), False);
			}
		if ( Teams > 3 )
			{
			Ystart += 64;
			Canvas.Style = ERenderStyle.STY_Translucent;
			Canvas.SetPos(0, Ystart);
			Canvas.DrawTile(Texture'Icon_GoldTeam', 64, 64, 0, 0, 128.0, 128.0);
			Canvas.Style = ERenderStyle.STY_Normal;
			Canvas.SetPos(64, Ystart + 32 - 0.5 * YL);
			Canvas.DrawText(int(GRI.Teams[3].Score), False);
			}
		}
}

defaultproperties
{
}
